//+------------------------------------------------------------------+
//|                                                   Guppy MACD.mq4 |
//|                      Copyright  2006, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
#property link      "cja"

#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1 DarkSlateGray  // HISTO
#property indicator_color2 Red // inside line
#property indicator_color3 Blue  // inside line
#property indicator_color4 Red  //middle line
#property indicator_color5 Blue  //middle line
#property indicator_color6 DarkOrange  // outside line
#property indicator_color7 DodgerBlue  //outside line
#property indicator_width1 3

//---- input parameters
extern int       FastEMA=8;
extern int       FFastEMA=7;
extern int       FFFastEMA=6;
extern int       SlowEMA=17;
extern int       SSlowEMA=16;
extern int       SSSlowEMA=15;
extern int       SignalSMA=9;
extern int       SSignalSMA=8;
extern int       SSSignalSMA=7;


//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double ExtMapBuffer5[];
double ExtMapBuffer6[];
double ExtMapBuffer7[];




//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {

//---- indicators
   SetIndexStyle(0,DRAW_HISTOGRAM);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexStyle(2,DRAW_LINE);
   SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(3,DRAW_LINE);
   SetIndexBuffer(3,ExtMapBuffer4);
   SetIndexStyle(4,DRAW_LINE);
   SetIndexBuffer(4,ExtMapBuffer5);
   SetIndexStyle(5,DRAW_LINE);
   SetIndexBuffer(5,ExtMapBuffer6);
   SetIndexStyle(6,DRAW_LINE);
   SetIndexBuffer(6,ExtMapBuffer7);
  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();

//----
   for(int i=Bars;i>=0;i--){
      ExtMapBuffer2[i]=iMACD(NULL,0,FastEMA,SlowEMA,SignalSMA,PRICE_CLOSE,MODE_MAIN,i); 
      ExtMapBuffer3[i]=iMACD(NULL,0,FastEMA,SlowEMA,SignalSMA,PRICE_CLOSE,MODE_SIGNAL,i);  
      ExtMapBuffer4[i]=iMACD(NULL,0,FFastEMA,SSlowEMA,SSignalSMA,PRICE_CLOSE,MODE_MAIN,i); 
      ExtMapBuffer5[i]=iMACD(NULL,0,FFastEMA,SSlowEMA,SSignalSMA,PRICE_CLOSE,MODE_SIGNAL,i);  
      ExtMapBuffer6[i]=iMACD(NULL,0,FFFastEMA,SSSlowEMA,SSSignalSMA,PRICE_CLOSE,MODE_MAIN,i); 
      ExtMapBuffer7[i]=iMACD(NULL,0,FFFastEMA,SSSlowEMA,SSSignalSMA,PRICE_CLOSE,MODE_SIGNAL,i); 
   
      ExtMapBuffer1[i]=ExtMapBuffer2[i] - ExtMapBuffer3[i];
      
   
      } 
      }
//----
   return(0);
  
//+------------------------------------------------------------------+